//
//  CeConnection.h
//  CeSQLiteConnect
//
//  Copyright 2006 __Cutedge Pte Ltd__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "sqlite3.h"
#import "CePreparedStatement.h"


@interface CeConnection : NSObject
{
	sqlite3		*_sqlHandler;
}

+ (id)connectionWithURL:(NSString *)url database:(NSString *)database user:(NSString *)user password:(NSString *)password;
- (void)close;

- (BOOL) initWithDatabase:(NSString *)database andHandler:(sqlite3 *)sqlHandler atPath:(NSString *)url;
- (CePreparedStatement *)prepareStatement:(NSString *)sqlStmt;

- (CeResultSet *)listTables;

- (sqlite3 *)sqlHandler;
- (void)setSqlHandler:(sqlite3 *)sqlHandler;

@end
